/************************************************************************
 * \file: iap2_cs_callbacks.h
 *
 * \version: $ $
 *
 * This header file declares callbacks associated with control session.
 *
 * \component: global definition file
 *
 * \author: Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
 *
 * \copyright: (c) 2010 - 2016 ADIT Corporation
 *
 * CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
 *          DO NOT CHANGE THE CODE MANUALLY
 ***********************************************************************/

#ifndef IAP2_CS_CALLBACKS_H_
#define IAP2_CS_CALLBACKS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "iap2_init.h"

/**
 * \addtogroup ControlSessionCallbacks
 * @{
 */

 /***************************************************************************//**
 * Callback function for AuthenticationFailed message
 * 
 * This callback will be called when AuthenticationFailed message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of AuthenticationFailed message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2AuthenticationFailedCallback) (iAP2Device_t* thisDevice, iAP2AuthenticationFailedParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for AuthenticationSucceeded message
 * 
 * This callback will be called when AuthenticationSucceeded message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of AuthenticationSucceeded message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2AuthenticationSucceededCallback) (iAP2Device_t* thisDevice, iAP2AuthenticationSucceededParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for RequestAuthenticationCertificate message
 * 
 * This callback will be called when RequestAuthenticationCertificate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of RequestAuthenticationCertificate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2RequestAuthenticationCertificateCallback) (iAP2Device_t* thisDevice, iAP2RequestAuthenticationCertificateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for RequestAuthenticationChallengeResponse message
 * 
 * This callback will be called when RequestAuthenticationChallengeResponse message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of RequestAuthenticationChallengeResponse message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2RequestAuthenticationChallengeResponseCallback) (iAP2Device_t* thisDevice, iAP2RequestAuthenticationChallengeResponseParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StartIdentification message
 * 
 * This callback will be called when StartIdentification message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StartIdentification message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StartIdentificationCallback) (iAP2Device_t* thisDevice, iAP2StartIdentificationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for IdentificationAccepted message
 * 
 * This callback will be called when IdentificationAccepted message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of IdentificationAccepted message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2IdentificationAcceptedCallback) (iAP2Device_t* thisDevice, iAP2IdentificationAcceptedParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for IdentificationRejected message
 * 
 * This callback will be called when IdentificationRejected message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of IdentificationRejected message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2IdentificationRejectedCallback) (iAP2Device_t* thisDevice, iAP2IdentificationRejectedParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for OOBBTPairingLinkKeyInformation message
 * 
 * This callback will be called when OOBBTPairingLinkKeyInformation message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of OOBBTPairingLinkKeyInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2OOBBTPairingLinkKeyInformationCallback) (iAP2Device_t* thisDevice, iAP2OOBBTPairingLinkKeyInformationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StartOOBBTPairing message
 * 
 * This callback will be called when StartOOBBTPairing message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StartOOBBTPairing message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StartOOBBTPairingCallback) (iAP2Device_t* thisDevice, iAP2StartOOBBTPairingParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StopOOBBTPairing message
 * 
 * This callback will be called when StopOOBBTPairing message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StopOOBBTPairing message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StopOOBBTPairingCallback) (iAP2Device_t* thisDevice, iAP2StopOOBBTPairingParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for RouteGuidanceManeuverUpdate message
 * 
 * This callback will be called when RouteGuidanceManeuverUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of RouteGuidanceManeuverUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2RouteGuidanceManeuverUpdateCallback) (iAP2Device_t* thisDevice, iAP2RouteGuidanceManeuverUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for RouteGuidanceUpdate message
 * 
 * This callback will be called when RouteGuidanceUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of RouteGuidanceUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2RouteGuidanceUpdateCallback) (iAP2Device_t* thisDevice, iAP2RouteGuidanceUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for AssistiveTouchInformation message
 * 
 * This callback will be called when AssistiveTouchInformation message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of AssistiveTouchInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2AssistiveTouchInformationCallback) (iAP2Device_t* thisDevice, iAP2AssistiveTouchInformationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for BluetoothConnectionUpdate message
 * 
 * This callback will be called when BluetoothConnectionUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of BluetoothConnectionUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2BluetoothConnectionUpdateCallback) (iAP2Device_t* thisDevice, iAP2BluetoothConnectionUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for CallStateUpdate message
 * 
 * This callback will be called when CallStateUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of CallStateUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2CallStateUpdateCallback) (iAP2Device_t* thisDevice, iAP2CallStateUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for CommunicationsUpdate message
 * 
 * This callback will be called when CommunicationsUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of CommunicationsUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2CommunicationsUpdateCallback) (iAP2Device_t* thisDevice, iAP2CommunicationsUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for ListUpdate message
 * 
 * This callback will be called when ListUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of ListUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2ListUpdateCallback) (iAP2Device_t* thisDevice, iAP2ListUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for DeviceAuthenticationCertificate message
 * 
 * This callback will be called when DeviceAuthenticationCertificate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of DeviceAuthenticationCertificate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2DeviceAuthenticationCertificateCallback) (iAP2Device_t* thisDevice, iAP2DeviceAuthenticationCertificateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for DeviceAuthenticationResponse message
 * 
 * This callback will be called when DeviceAuthenticationResponse message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of DeviceAuthenticationResponse message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2DeviceAuthenticationResponseCallback) (iAP2Device_t* thisDevice, iAP2DeviceAuthenticationResponseParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for DeviceInformationUpdate message
 * 
 * This callback will be called when DeviceInformationUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of DeviceInformationUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2DeviceInformationUpdateCallback) (iAP2Device_t* thisDevice, iAP2DeviceInformationUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for DeviceLanguageUpdate message
 * 
 * This callback will be called when DeviceLanguageUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of DeviceLanguageUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2DeviceLanguageUpdateCallback) (iAP2Device_t* thisDevice, iAP2DeviceLanguageUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for DeviceTimeUpdate message
 * 
 * This callback will be called when DeviceTimeUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of DeviceTimeUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2DeviceTimeUpdateCallback) (iAP2Device_t* thisDevice, iAP2DeviceTimeUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for DeviceUUIDUpdate message
 * 
 * This callback will be called when DeviceUUIDUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of DeviceUUIDUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2DeviceUUIDUpdateCallback) (iAP2Device_t* thisDevice, iAP2DeviceUUIDUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for WirelessCarPlayUpdate message
 * 
 * This callback will be called when WirelessCarPlayUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of WirelessCarPlayUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2WirelessCarPlayUpdateCallback) (iAP2Device_t* thisDevice, iAP2WirelessCarPlayUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for DeviceTransportIdentifierNotification message
 * 
 * This callback will be called when DeviceTransportIdentifierNotification message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of DeviceTransportIdentifierNotification message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2DeviceTransportIdentifierNotificationCallback) (iAP2Device_t* thisDevice, iAP2DeviceTransportIdentifierNotificationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StartExternalAccessoryProtocolSession message
 * 
 * This callback will be called when StartExternalAccessoryProtocolSession message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StartExternalAccessoryProtocolSession message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StartExternalAccessoryProtocolSessionCallback) (iAP2Device_t* thisDevice, iAP2StartExternalAccessoryProtocolSessionParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StopExternalAccessoryProtocolSession message
 * 
 * This callback will be called when StopExternalAccessoryProtocolSession message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StopExternalAccessoryProtocolSession message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StopExternalAccessoryProtocolSessionCallback) (iAP2Device_t* thisDevice, iAP2StopExternalAccessoryProtocolSessionParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for DeviceHIDReport message
 * 
 * This callback will be called when DeviceHIDReport message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of DeviceHIDReport message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2DeviceHIDReportCallback) (iAP2Device_t* thisDevice, iAP2DeviceHIDReportParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StartNativeHID message
 * 
 * This callback will be called when StartNativeHID message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StartNativeHID message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StartNativeHIDCallback) (iAP2Device_t* thisDevice, iAP2StartNativeHIDParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for GPRMCDataStatusValuesNotification message
 * 
 * This callback will be called when GPRMCDataStatusValuesNotification message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of GPRMCDataStatusValuesNotification message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2GPRMCDataStatusValuesNotificationCallback) (iAP2Device_t* thisDevice, iAP2GPRMCDataStatusValuesNotificationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StartLocationInformation message
 * 
 * This callback will be called when StartLocationInformation message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StartLocationInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StartLocationInformationCallback) (iAP2Device_t* thisDevice, iAP2StartLocationInformationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StopLocationInformation message
 * 
 * This callback will be called when StopLocationInformation message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StopLocationInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StopLocationInformationCallback) (iAP2Device_t* thisDevice, iAP2StopLocationInformationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for MediaLibraryInformation message
 * 
 * This callback will be called when MediaLibraryInformation message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of MediaLibraryInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2MediaLibraryInformationCallback) (iAP2Device_t* thisDevice, iAP2MediaLibraryInformationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for MediaLibraryUpdate message
 * 
 * This callback will be called when MediaLibraryUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of MediaLibraryUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2MediaLibraryUpdateCallback) (iAP2Device_t* thisDevice, iAP2MediaLibraryUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for NowPlayingUpdate message
 * 
 * This callback will be called when NowPlayingUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of NowPlayingUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2NowPlayingUpdateParameterCallback) (iAP2Device_t* thisDevice, iAP2NowPlayingUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for PowerUpdate message
 * 
 * This callback will be called when PowerUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of PowerUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2PowerUpdateCallback) (iAP2Device_t* thisDevice, iAP2PowerUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for TelephonyCallStateInformation message
 * 
 * This callback will be called when TelephonyCallStateInformation message is
 * received from apple device and parsed
 * CAUTION: The call back function TelephonyCallStateInformationParameter is Deprecated, Don't use it. Kindly refer the Apple Specification.
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of TelephonyCallStateInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2TelephonyCallStateInformationCallback) (iAP2Device_t* thisDevice, iAP2TelephonyCallStateInformationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for TelephonyUpdate message
 * 
 * This callback will be called when TelephonyUpdate message is
 * received from apple device and parsed
 * CAUTION: The call back function TelephonyUpdateParameter is Deprecated, Don't use it. Kindly refer the Apple Specification.
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of TelephonyUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2TelephonyUpdateCallback) (iAP2Device_t* thisDevice, iAP2TelephonyUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for USBDeviceModeAudioInformation message
 * 
 * This callback will be called when USBDeviceModeAudioInformation message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of USBDeviceModeAudioInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2USBDeviceModeAudioInformationCallback) (iAP2Device_t* thisDevice, iAP2USBDeviceModeAudioInformationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StartVehicleStatusUpdates message
 * 
 * This callback will be called when StartVehicleStatusUpdates message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StartVehicleStatusUpdates message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StartVehicleStatusUpdatesCallback) (iAP2Device_t* thisDevice, iAP2StartVehicleStatusUpdatesParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for StopVehicleStatusUpdates message
 * 
 * This callback will be called when StopVehicleStatusUpdates message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of StopVehicleStatusUpdates message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2StopVehicleStatusUpdatesCallback) (iAP2Device_t* thisDevice, iAP2StopVehicleStatusUpdatesParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for VoiceOverCursorUpdate message
 * 
 * This callback will be called when VoiceOverCursorUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of VoiceOverCursorUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2VoiceOverCursorUpdateCallback) (iAP2Device_t* thisDevice, iAP2VoiceOverCursorUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for VoiceOverUpdate message
 * 
 * This callback will be called when VoiceOverUpdate message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of VoiceOverUpdate message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2VoiceOverUpdateCallback) (iAP2Device_t* thisDevice, iAP2VoiceOverUpdateParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for RequestAccessoryWiFiConfigurationInformation message
 * 
 * This callback will be called when RequestAccessoryWiFiConfigurationInformation message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of RequestAccessoryWiFiConfigurationInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2RequestAccessoryWiFiConfigurationInformationCallback) (iAP2Device_t* thisDevice, iAP2RequestAccessoryWiFiConfigurationInformationParameter* thisParameter, void* context);

 /***************************************************************************//**
 * Callback function for WiFiInformation message
 * 
 * This callback will be called when WiFiInformation message is
 * received from apple device and parsed
 * 
 * \param[in] thisDevice Initialized device structure
 * \param[in] thisParameter Parameter structure of WiFiInformation message
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
typedef S32 (*iAP2WiFiInformationCallback) (iAP2Device_t* thisDevice, iAP2WiFiInformationParameter* thisParameter, void* context);

/** @} */

struct _iAP2CSCallbacks
{
    iAP2AuthenticationFailedCallback                         iAP2AuthenticationFailed_cb;
    iAP2AuthenticationSucceededCallback                      iAP2AuthenticationSucceeded_cb;
    iAP2RequestAuthenticationCertificateCallback             iAP2RequestAuthenticationCertificate_cb;
    iAP2RequestAuthenticationChallengeResponseCallback       iAP2RequestAuthenticationChallengeResponse_cb;
    iAP2StartIdentificationCallback                          iAP2StartIdentification_cb;
    iAP2IdentificationAcceptedCallback                       iAP2IdentificationAccepted_cb;
    iAP2IdentificationRejectedCallback                       iAP2IdentificationRejected_cb;
    iAP2OOBBTPairingLinkKeyInformationCallback               iAP2OOBBTPairingLinkKeyInformation_cb;
    iAP2StartOOBBTPairingCallback                            iAP2StartOOBBTPairing_cb;
    iAP2StopOOBBTPairingCallback                             iAP2StopOOBBTPairing_cb;
    iAP2RouteGuidanceManeuverUpdateCallback                  iAP2RouteGuidanceManeuverUpdate_cb;
    iAP2RouteGuidanceUpdateCallback                          iAP2RouteGuidanceUpdate_cb;
    iAP2AssistiveTouchInformationCallback                    iAP2AssistiveTouchInformation_cb;
    iAP2BluetoothConnectionUpdateCallback                    iAP2BluetoothConnectionUpdate_cb;
    iAP2CallStateUpdateCallback                              iAP2CallStateUpdate_cb;
    iAP2CommunicationsUpdateCallback                         iAP2CommunicationsUpdate_cb;
    iAP2ListUpdateCallback                                   iAP2ListUpdate_cb;
    iAP2DeviceAuthenticationCertificateCallback              iAP2DeviceAuthenticationCertificate_cb;
    iAP2DeviceAuthenticationResponseCallback                 iAP2DeviceAuthenticationResponse_cb;
    iAP2DeviceInformationUpdateCallback                      iAP2DeviceInformationUpdate_cb;
    iAP2DeviceLanguageUpdateCallback                         iAP2DeviceLanguageUpdate_cb;
    iAP2DeviceTimeUpdateCallback                             iAP2DeviceTimeUpdate_cb;
    iAP2DeviceUUIDUpdateCallback                             iAP2DeviceUUIDUpdate_cb;
    iAP2WirelessCarPlayUpdateCallback                        iAP2WirelessCarPlayUpdate_cb;
    iAP2DeviceTransportIdentifierNotificationCallback        iAP2DeviceTransportIdentifierNotification_cb;
    iAP2StartExternalAccessoryProtocolSessionCallback        iAP2StartExternalAccessoryProtocolSession_cb;
    iAP2StopExternalAccessoryProtocolSessionCallback         iAP2StopExternalAccessoryProtocolSession_cb;
    iAP2DeviceHIDReportCallback                              iAP2DeviceHIDReport_cb;
    iAP2StartNativeHIDCallback                               iAP2StartNativeHID_cb;
    iAP2GPRMCDataStatusValuesNotificationCallback            iAP2GPRMCDataStatusValuesNotification_cb;
    iAP2StartLocationInformationCallback                     iAP2StartLocationInformation_cb;
    iAP2StopLocationInformationCallback                      iAP2StopLocationInformation_cb;
    iAP2MediaLibraryInformationCallback                      iAP2MediaLibraryInformation_cb;
    iAP2MediaLibraryUpdateCallback                           iAP2MediaLibraryUpdate_cb;
    iAP2NowPlayingUpdateParameterCallback                    iAP2NowPlayingUpdateParameter_cb;
    iAP2PowerUpdateCallback                                  iAP2PowerUpdate_cb;
    iAP2TelephonyCallStateInformationCallback                iAP2TelephonyCallStateInformation_cb;
    iAP2TelephonyUpdateCallback                              iAP2TelephonyUpdate_cb;
    iAP2USBDeviceModeAudioInformationCallback                iAP2USBDeviceModeAudioInformation_cb;
    iAP2StartVehicleStatusUpdatesCallback                    iAP2StartVehicleStatusUpdates_cb;
    iAP2StopVehicleStatusUpdatesCallback                     iAP2StopVehicleStatusUpdates_cb;
    iAP2VoiceOverCursorUpdateCallback                        iAP2VoiceOverCursorUpdate_cb;
    iAP2VoiceOverUpdateCallback                              iAP2VoiceOverUpdate_cb;
    iAP2RequestAccessoryWiFiConfigurationInformationCallback iAP2RequestAccessoryWiFiConfigurationInformation_cb;
    iAP2WiFiInformationCallback                              iAP2WiFiInformation_cb;
};
typedef struct _iAP2CSCallbacks iAP2SessionCallbacks_t;

#ifdef __cplusplus
}
#endif

#endif
